function [groundtruth, pred, Score, test_data] = predict_test(model, test_filename, feature_num)
% PREDICT_TEST Predict labels for the test dataset using a trained model.
% 
% Inputs:
%   model         - The trained Naive Bayes model.
%   test_filename - File name of the test dataset (Excel format).
%   feature_num   - Number of features used in training.
%
% Outputs:
%   groundtruth - True labels from the test set, or -1.532 if labels are missing.
%   pred        - Predicted labels from the model.
%   Score       - Probability scores for each class.
%   test_data   - Raw data read from the test file.

    % Read test data from Excel file
    test_data = xlsread(test_filename);

    % Get number of test samples and number of columns in test data
    [test_sample_num, test_column_num] = size(test_data);

    % If the number of columns equals the number of features,
    % assume the test data has no label column
    if test_column_num == feature_num
        groundtruth = -1.532;            % Assign special value to indicate missing labels
        X = test_data(:, 1:end);         % Use all columns as features
        [pred, Score] = predict(model, X);  % Predict using the trained model
    else
        groundtruth = test_data(:, end);     % Use the last column as ground truth labels
        X = test_data(:, 1:end-1);           % Use the rest as features
        [pred, Score] = predict(model, X);   % Predict using the trained model
    end    

    % Display the number of test samples
    disp('test_sample_num: ')
    fprintf(' %d \n', test_sample_num);
end
